/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.CopyPasteRender;
import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.capability.provider.TemplateKeyProvider;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideBuildSizeCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideCopySizeCommand;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementChecker;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.building.view.WorldBuildView;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.CopyScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.PlacementScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.save.SaveManager;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.Additions;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.ModeTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class GadgetCopyPaste
extends AbstractGadget {
    private static final Joiner CHUNK_JOINER = Joiner.on((String)"; ");

    public GadgetCopyPaste() {
        super(OurItems.nonStackableItemProperties(), () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_COPY_PASTE.undoSize).get(), "buildinggadgets_undo_copy_paste", Reference.BlockReference.TagReference.WHITELIST_COPY_PASTE, Reference.BlockReference.TagReference.BLACKLIST_COPY_PASTE);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_COPY_PASTE.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return CopyPasteRender::new;
    }

    @Override
    public CopyPasteRender getRender() {
        return (CopyPasteRender)super.getRender();
    }

    @Override
    protected void addCapabilityProviders(ImmutableList.Builder<ICapabilityProvider> providerBuilder, ItemStack stack, @Nullable CompoundTag tag) {
        super.addCapabilityProviders(providerBuilder, stack, tag);
        providerBuilder.add((Object)new TemplateKeyProvider(stack));
    }

    @Override
    public boolean performRotate(ItemStack stack, Player player) {
        return player.f_19853_.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).map(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).map(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            provider.setTemplate((ITemplateKey)key, template.rotate(Rotation.CLOCKWISE_90));
            provider.requestRemoteUpdate((ITemplateKey)key, PacketDistributor.PLAYER.with(() -> (ServerPlayer)player));
            return true;
        }).orElse(false)).orElse(false);
    }

    @Override
    public boolean performMirror(ItemStack stack, Player player) {
        return player.f_19853_.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).map(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).map(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            provider.setTemplate((ITemplateKey)key, template.mirror(player.m_6350_().m_122434_()));
            provider.requestRemoteUpdate((ITemplateKey)key, PacketDistributor.PLAYER.with(() -> (ServerPlayer)player));
            return true;
        }).orElse(false)).orElse(false);
    }

    public static void setRelativeVector(ItemStack stack, BlockPos vec) {
        CompoundTag nbt = stack.m_41784_();
        if (vec.equals((Object)BlockPos.f_121853_)) {
            nbt.m_128473_("rel_pos");
        } else {
            nbt.m_128365_("rel_pos", (Tag)NbtUtils.m_129224_((BlockPos)vec));
        }
    }

    public static BlockPos getRelativeVector(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("rel_pos"));
    }

    public static int getCopyCounter(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128451_("copy_count");
    }

    public static int getAndIncrementCopyCounter(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        int count = nbt.m_128451_("copy_count");
        nbt.m_128405_("copy_count", count + 1);
        return count;
    }

    public static Optional<BlockPos> getActivePos(Player playerEntity, ItemStack stack) {
        BlockPos pos = ((AbstractGadget)stack.m_41720_()).getAnchor(stack);
        if (pos == null) {
            BlockHitResult res = VectorHelper.getLookingAt(playerEntity, stack);
            if (res == null || res.m_6662_() == HitResult.Type.MISS) {
                return Optional.empty();
            }
            pos = res.m_82425_().m_142300_(res.m_82434_());
        }
        return Optional.of(pos).map(p -> p.m_141952_((Vec3i)GadgetCopyPaste.getRelativeVector(stack)));
    }

    public static Optional<Region> getSelectedRegion(ItemStack stack) {
        BlockPos lower = GadgetCopyPaste.getLowerRegionBound(stack);
        BlockPos upper = GadgetCopyPaste.getUpperRegionBound(stack);
        if (lower != null && upper != null) {
            return Optional.of(new Region((Vec3i)lower, (Vec3i)upper));
        }
        return Optional.empty();
    }

    public static void setSelectedRegion(ItemStack stack, @Nullable Region region) {
        if (region != null) {
            GadgetCopyPaste.setLowerRegionBound(stack, region.getMin());
            GadgetCopyPaste.setUpperRegionBound(stack, region.getMax());
        } else {
            GadgetCopyPaste.setLowerRegionBound(stack, null);
            GadgetCopyPaste.setUpperRegionBound(stack, null);
        }
    }

    public static void setUpperRegionBound(ItemStack stack, @Nullable BlockPos pos) {
        CompoundTag nbt = stack.m_41784_();
        if (pos != null) {
            nbt.m_128365_("start_pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        } else {
            nbt.m_128473_("start_pos");
        }
    }

    public static void setLowerRegionBound(ItemStack stack, @Nullable BlockPos pos) {
        CompoundTag nbt = stack.m_41784_();
        if (pos != null) {
            nbt.m_128365_("end_pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        } else {
            nbt.m_128473_("end_pos");
        }
    }

    @Nullable
    public static BlockPos getUpperRegionBound(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128425_("start_pos", 10)) {
            return NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("start_pos"));
        }
        return null;
    }

    @Nullable
    public static BlockPos getLowerRegionBound(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128425_("end_pos", 10)) {
            return NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("end_pos"));
        }
        return null;
    }

    private static void setToolMode(ItemStack stack, ToolMode mode) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128344_("mode", mode.getId());
    }

    public static ToolMode getToolMode(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        ToolMode mode = ToolMode.COPY;
        if (!tagCompound.m_128425_("mode", 1)) {
            GadgetCopyPaste.setToolMode(stack, mode);
            return mode;
        }
        mode = ToolMode.ofId(tagCompound.m_128445_("mode"));
        if (mode == null) {
            BuildingGadgets.LOG.debug("Failed to read Tool Mode {} falling back to {}.", (Object)tagCompound.m_128461_("mode"), (Object)mode);
            mode = ToolMode.COPY;
            GadgetCopyPaste.setToolMode(stack, mode);
        }
        return mode;
    }

    @Override
    protected void onAnchorSet(ItemStack stack, Player player, BlockHitResult lookingAt) {
        super.onAnchorSet(stack, player, new BlockHitResult(lookingAt.m_82450_(), lookingAt.m_82434_(), lookingAt.m_82425_().m_142300_(lookingAt.m_82434_()), lookingAt.m_82436_()));
    }

    public static ItemStack getGadget(Player player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.m_41720_() instanceof GadgetCopyPaste)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add((Component)TooltipTranslation.GADGET_MODE.componentTranslation(GadgetCopyPaste.getToolMode((ItemStack)stack).translation.format(new Object[0])).m_6270_(Styles.AQUA));
        tooltip.add((Component)new TextComponent("My renders don't really work yet, outlines for now :D").m_6270_(Styles.GRAY));
        GadgetCopyPaste.addInformationRayTraceFluid(tooltip, stack);
        GadgetUtils.addTooltipNameAndAuthor(stack, world, tooltip);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ToolMode mode = ToolMode.values()[modeInt];
        GadgetCopyPaste.setToolMode(heldItem, mode);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        boolean lookingAtInventory;
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        BlockHitResult posLookingAt = VectorHelper.getLookingAt(player, stack);
        BlockEntity tileEntity = world.m_7702_(posLookingAt.m_82425_());
        boolean bl = lookingAtInventory = tileEntity != null && tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
        if (!world.m_5776_()) {
            if (player.m_6144_() && lookingAtInventory) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.COPY) {
                if (world.m_8055_(posLookingAt.m_82425_()) != Blocks.f_50016_.m_49966_()) {
                    this.setRegionAndCopy(stack, world, player, posLookingAt.m_82425_());
                }
            } else if (GadgetCopyPaste.getToolMode(stack) == ToolMode.PASTE && !player.m_6144_()) {
                GadgetCopyPaste.getActivePos(player, stack).ifPresent(pos -> this.build(stack, world, player, (BlockPos)pos));
            }
        } else {
            if (player.m_6144_() && Screen.m_96637_() && lookingAtInventory) {
                PacketHandler.sendToServer(new PacketBindTool());
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.COPY) {
                if (player.m_6144_() && world.m_8055_(posLookingAt.m_82425_()) == Blocks.f_50016_.m_49966_()) {
                    GuiMod.COPY.openScreen(player);
                }
            } else if (player.m_6144_()) {
                GuiMod.PASTE.openScreen(player);
            } else {
                BaseRenderer.updateInventoryCache();
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack p_150902_) {
        return Optional.of(new EventTooltip.CopyPasteTooltipComponent.Data(p_150902_));
    }

    private void setRegionAndCopy(ItemStack stack, Level world, Player player, BlockPos lookedAt) {
        if (player.m_6144_()) {
            if (GadgetCopyPaste.getLowerRegionBound(stack) != null && !this.checkCopy(world, player, new Region((Vec3i)lookedAt, (Vec3i)GadgetCopyPaste.getLowerRegionBound(stack)))) {
                return;
            }
            GadgetCopyPaste.setUpperRegionBound(stack, lookedAt);
        } else {
            if (GadgetCopyPaste.getUpperRegionBound(stack) != null && !this.checkCopy(world, player, new Region((Vec3i)lookedAt, (Vec3i)GadgetCopyPaste.getUpperRegionBound(stack)))) {
                return;
            }
            GadgetCopyPaste.setLowerRegionBound(stack, lookedAt);
        }
        Optional<Region> regionOpt = GadgetCopyPaste.getSelectedRegion(stack);
        if (!regionOpt.isPresent()) {
            player.m_5661_((Component)MessageTranslation.FIRST_COPY.componentTranslation(new Object[0]).m_6270_(Styles.DK_GREEN), true);
        }
        regionOpt.ifPresent(region -> this.tryCopy(stack, world, player, (Region)region));
    }

    public void tryCopy(ItemStack stack, Level world, Player player, Region region) {
        BuildContext context = BuildContext.builder().player(player).stack(stack).build((LevelAccessor)world);
        WorldBuildView buildView = WorldBuildView.create(context, region, (c, p) -> InventoryHelper.getSafeBlockData(player, p, player.m_7655_()));
        this.performCopy(stack, buildView);
    }

    private boolean checkCopy(Level world, Player player, Region region) {
        ImmutableSortedSet<ChunkPos> unloaded;
        if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloaded = region.getUnloadedChunks((LevelReader)world)).isEmpty()) {
            player.m_5661_((Component)MessageTranslation.COPY_UNLOADED.componentTranslation(unloaded.size()).m_6270_(Styles.RED), true);
            BuildingGadgets.LOG.debug("Prevented copy because {} chunks where detected as unloaded.", (Object)unloaded.size());
            BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", (Object)CHUNK_JOINER.join(unloaded));
            return false;
        }
        int maxDimension = (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxCopySize.get();
        if (region.getXSize() > 65535 || region.getYSize() > 255 || region.getZSize() > 65535 || (region.getXSize() > maxDimension || region.getYSize() > maxDimension || region.getZSize() > maxDimension) && !OverrideCopySizeCommand.mayPerformLargeCopy(player)) {
            BlockPos sizeVec = region.getMax().m_141950_((Vec3i)region.getMin());
            player.m_5661_((Component)MessageTranslation.COPY_TOO_LARGE.componentTranslation(sizeVec.m_123341_(), sizeVec.m_123342_(), sizeVec.m_123343_(), Math.min(maxDimension, 65535), Math.min(maxDimension, 255), Math.min(maxDimension, 65535)).m_6270_(Styles.RED), true);
            return false;
        }
        return true;
    }

    private void performCopy(ItemStack stack, WorldBuildView buildView) {
        BuildContext context = buildView.getContext();
        assert (context.getPlayer() != null);
        Player player = context.getPlayer();
        CopyScheduler.scheduleCopy((map, region) -> {
            Template newTemplate = new Template((ImmutableMap<BlockPos, BlockData>)map, TemplateHeader.builder(region).name("Copy " + GadgetCopyPaste.getAndIncrementCopyCounter(stack)).author(player.m_7755_().m_6111_()).build());
            this.onCopyFinished(newTemplate.normalize(), stack, player);
        }, buildView, (Integer)Config.GADGETS.GADGET_COPY_PASTE.copySteps.get());
    }

    private void onCopyFinished(Template newTemplate, ItemStack stack, Player player) {
        if (!Additions.sizeInvalid(player, newTemplate.getHeader().getBoundingBox())) {
            this.sendMessage(stack, player, MessageTranslation.AREA_COPIED, Styles.DK_GREEN);
        }
        ITemplateKey key = (ITemplateKey)stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).orElseThrow(CapabilityNotPresentException::new);
        SaveManager.INSTANCE.getTemplateProvider().setTemplate(key, newTemplate);
        SaveManager.INSTANCE.getTemplateProvider().requestRemoteUpdate(key, (ServerPlayer)player);
    }

    private void build(ItemStack stack, Level world, Player player, BlockPos pos) {
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            BuildContext buildContext = BuildContext.builder().stack(stack).player(player).build((LevelAccessor)world);
            IBuildView view = template.createViewInContext(buildContext);
            view.translateTo(pos);
            if (!this.checkPlacement(world, player, view.getBoundingBox())) {
                return;
            }
            this.schedulePlacement(stack, view, player);
        }));
    }

    private boolean checkPlacement(Level world, Player player, Region region) {
        ImmutableSortedSet<ChunkPos> unloaded;
        if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloaded = region.getUnloadedChunks((LevelReader)world)).isEmpty()) {
            player.m_5661_((Component)MessageTranslation.BUILD_UNLOADED.componentTranslation(unloaded.size()).m_6270_(Styles.RED), true);
            BuildingGadgets.LOG.debug("Prevented build because {} chunks where detected as unloaded.", (Object)unloaded.size());
            BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", (Object)CHUNK_JOINER.join(unloaded));
            return false;
        }
        int maxDimension = (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxBuildSize.get();
        if (!(region.getXSize() <= maxDimension && region.getYSize() <= maxDimension && region.getZSize() <= maxDimension || OverrideBuildSizeCommand.mayPerformLargeBuild(player))) {
            BlockPos sizeVec = region.getMax().m_141950_((Vec3i)region.getMin());
            player.m_5661_((Component)MessageTranslation.BUILD_TOO_LARGE.componentTranslation(sizeVec.m_123341_(), sizeVec.m_123342_(), sizeVec.m_123343_(), maxDimension, maxDimension, maxDimension).m_6270_(Styles.RED), true);
            return false;
        }
        return true;
    }

    private void schedulePlacement(ItemStack stack, IBuildView view, Player player) {
        IItemIndex index = InventoryHelper.index(stack, player);
        int energyCost = this.getEnergyMax() == 0 ? 0 : this.getEnergyCost(stack);
        boolean overwrite = (Boolean)Config.GENERAL.allowOverwriteBlocks.get();
        BlockPlaceContext useContext = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, VectorHelper.getLookingAt(player, stack)));
        PlacementChecker checker = new PlacementChecker((LazyOptional<IEnergyStorage>)stack.getCapability(CapabilityEnergy.ENERGY), t -> energyCost, index, (c, t) -> overwrite ? c.getWorld().m_8055_(t.getPos()).m_60629_(useContext) : c.getWorld().m_46859_(t.getPos()), true);
        PlacementScheduler.schedulePlacement(view, checker, (Integer)Config.GADGETS.placeSteps.get()).withFinisher(p -> {
            this.pushUndo(stack, p.getUndoBuilder().build((Level)view.getContext().getServerWorld()));
            this.onBuildFinished(stack, player, view.getBoundingBox());
        });
    }

    private void onBuildFinished(ItemStack stack, Player player, Region bounds) {
        if (!Additions.sizeInvalid(player, bounds)) {
            this.sendMessage(stack, player, MessageTranslation.TEMPLATE_BUILD, Styles.DK_GREEN);
        }
    }

    private void sendMessage(ItemStack stack, Player player, ITranslationProvider messageSource, Style style) {
        player.m_5661_((Component)messageSource.componentTranslation(new Object[0]).m_6270_(style), true);
    }

    public static final class ToolMode
    extends Enum<ToolMode> {
        public static final /* enum */ ToolMode COPY = new ToolMode(ModeTranslation.COPY, 0);
        public static final /* enum */ ToolMode PASTE = new ToolMode(ModeTranslation.PASTE, 1);
        public static final ToolMode[] VALUES;
        private static final Byte2ObjectMap<ToolMode> BY_ID;
        private final byte id;
        private final ITranslationProvider translation;
        private static final /* synthetic */ ToolMode[] $VALUES;

        public static ToolMode[] values() {
            return (ToolMode[])$VALUES.clone();
        }

        public static ToolMode valueOf(String name) {
            return Enum.valueOf(ToolMode.class, name);
        }

        private ToolMode(ITranslationProvider translation, int id) {
            this.id = (byte)id;
            this.translation = translation;
        }

        public byte getId() {
            return this.id;
        }

        @Nullable
        public static ToolMode ofId(byte id) {
            return (ToolMode)((Object)BY_ID.get(id));
        }

        public ITranslationProvider getTranslation() {
            return this.translation;
        }

        private static /* synthetic */ ToolMode[] $values() {
            return new ToolMode[]{COPY, PASTE};
        }

        static {
            $VALUES = ToolMode.$values();
            VALUES = ToolMode.values();
            BY_ID = new Byte2ObjectOpenHashMap();
            for (ToolMode mode : VALUES) {
                assert (!BY_ID.containsKey(mode.getId()));
                BY_ID.put(mode.getId(), (Object)mode);
            }
        }
    }
}

